// src/machine/machine.service.ts
import { Injectable } from '@nestjs/common';
import { PrismaService } from 'src/prisma/prisma.service';

@Injectable()
export class MachineService {
  constructor(private prisma: PrismaService) {}

  /**
   * Retrieves a single machine by its unique ID.
   * 
   * @param id - The ID of the machine to retrieve.
   * @returns A Promise resolving to the machine object if found, otherwise null.
   */
  async getMachineById(id: number) {
    return this.prisma.machine.findUnique({
      where: { id },
    });
  }

  /**
   * Retrieves all machines from the database.
   * 
   * @returns A Promise resolving to an array of all machine objects.
   */
  async getAllMachines() {
    return this.prisma.machine.findMany();
  }

  /**
   * Retrieves a node from a specific machine from the database.
   * 
   * @returns A Promise returning the node object associated with the machine.
   */
  // machine.service.ts
  async getMachineNodeById(id: number) {
    return this.prisma.machine.findUnique({
      where: { id },
      select: { nodeId: true },
    });
  }
  
}
